package gov.va.vinci.dart.dms.db.impl;

import javax.persistence.Query;

import gov.va.vinci.dart.db.util.HibernateDAO;
import gov.va.vinci.dart.dms.biz.Attribute;
import gov.va.vinci.dart.dms.db.AttributeDAO;

public class AttributeDAOImpl extends HibernateDAO implements AttributeDAO {

	@Override
	public Attribute findById(final int attributeId) {
		Query q = createQuery("from Attribute where id=:aid");
		q.setParameter("aid", attributeId);
		return (Attribute)q.getSingleResult();
	}

	@Override
	public void save(Attribute attribute) {
		if (attribute == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(attribute);
	}

	@Override
	public void delete(Attribute attribute) {
		if (attribute == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(attribute);
	}

}
